package org.semanticweb.ruqar.examples;

import java.util.List;

import org.semanticweb.ruqar.owl.OWLReasoning;
import org.semanticweb.ruqar.rules.Rule;
import org.semanticweb.ruqar.transformations.OWLIntoRules;
import org.semanticweb.ruqar.transformations.RulesIntoDroolsRules;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.ruqar.utils.Triple;

/**
 * Example class how to transform OWL 2 ontology into Drools rules.
 * @author Jaroslaw Bak
 *
 */
public class OntologyToDroolsExample {
	
	public static void main(String[] args) {
		
		//set input files
		String path = "./ontologies/";
		String fileName = "vicodi_0/vicodi_0.owl";
		
		//load an ontology
		OWLReasoning reasoning = new OWLReasoning(path+fileName, null);
		
		//check if an ontology is withing the OWL 2 Profile
		System.out.println(reasoning.getOWL2ProfileInformation());
		
		//you need to remove SWRL rules since HermiT does not handle them
		//reasoning.removeSWRLRulesFromOntology();
		OWLOntology newOnto = reasoning.doReasoning(true, false);
		//reasoning.restoreSWRLRulesInOntology(); //you can restore rules here
		
		//OWL 2 ontology into rules
		OWLIntoRules trans = new OWLIntoRules(newOnto);
		
		//Transform OWL 2 ontology into ASRF rules
		List<Rule> allRules = trans.getAllOntologyAndSWRLAsRules();
		
		//Print transformed ASRF rules
		System.out.println("Number of generated rules: " + allRules.size());
		for(Rule r : allRules)
		{
			System.out.println("OWLAxiom: " + r.getOWLAxiom() + "\n" + r.prettyPrint() +"Rule is safe? " + r.isSafe() + "\n");
		}
		
		//Transform ASRF rules into Drools rules
		RulesIntoDroolsRules droolsRules = new RulesIntoDroolsRules();
		List<String> drools = droolsRules.getTransformatedRules(trans.getAllOntologyAndSWRLAsRules());
		for(String s : drools)
		{
			System.out.println(s);
		}
		
		//transform and print facts
		List<Triple> triples = droolsRules.getTransformatedData(trans.getAllAssertionsAsAtoms());
		for(Triple tr : triples) System.out.println(tr.toString());
		
		//save Drools rules
		droolsRules.saveRulesToFile(path+fileName+".drl", drools);
	}
}
